<?php
if (!defined('ADDFUNDS')) {
    http_response_code(404);
    die();
}

// Get Credentials from Method Extras
$apiKey = $methodExtras["api_key"];
$secretKey = $methodExtras["api_secret"]; // Assuming you will add this field in admin
$brandKey = $methodExtras["brand_key"];   // Assuming you will add this field in admin
$exchangeRate = $methodExtras["exchange_rate"] ?: 1;

$payeeName = $user["name"] ?: "User";
$payeeEmail = $user["email"] ?: "test@test.com";
$paymentURL = site_url("payment/" . $methodCallback);
$orderId = md5(RAND_STRING(5) . time());

// Insert into local DB
$insert = $conn->prepare(
    "INSERT INTO payments SET
    client_id=:client_id,
    payment_amount=:amount,
    payment_method=:method,
    payment_mode=:mode,
    payment_create_date=:date,
    payment_ip=:ip,
    payment_extra=:extra"
);

$insert->execute([
    "client_id" => $user["client_id"],
    "amount" => $paymentAmount,
    "method" => $methodId,
    "mode" => "Automatic",
    "date" => date("Y.m.d H:i:s"),
    "ip" => GetIP(),
    "extra" => $orderId
]);

// Prepare API Request
$requestData = [
    'cus_name'      => $payeeName,
    'cus_email'     => $payeeEmail,
    'amount'        => round($paymentAmount * $exchangeRate, 2),
    'order_id'      => $orderId,
    'metadata'      => [
        'order_id' => $orderId
    ],
    'success_url'   => $paymentURL,
    'cancel_url'    => site_url("addfunds"),
    'webhook_url'   => $paymentURL
];

$postUrl = "https://secure.epay.com.bd/api/payment/create";

$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => $postUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode($requestData),
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "API-KEY: " . $apiKey,
        "SECRET-KEY: " . $secretKey,
        "BRAND-KEY: " . $brandKey
    ],
]);

$upresponse = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    errorExit("cURL Error #:" . $err);
} else {
    $result = json_decode($upresponse, true);
    if (isset($result['status']) && $result['status'] == 'success' && isset($result['payment_url'])) {
        $paymentUrl = $result['payment_url'];
        // Redirect to payment URL
        $redirectForm = '<script type="text/javascript">window.location.href = "' . $paymentUrl . '";</script>';
    } else {
        errorExit($result['message'] ?? 'Unknown Error');
    }
}

$response["success"] = true;
$response["message"] = "Your payment has been initiated and you will now be redirected to the payment gateway.";
$response["content"] = $redirectForm;