<?php
if (!defined('PAYMENT')) {
    http_response_code(404);
    die();
}

// Get Credentials
$apiKey = $methodExtras["api_key"];
$secretKey = $methodExtras["api_secret"];
$brandKey = $methodExtras["brand_key"];

// Get Payment ID from GET request
$paymentId = $_GET['payment_id'];

if (!$paymentId) {
    die("Payment ID missing");
}

// Verify Payment
$verifyUrl = "https://secure.epay.com.bd/api/payment/verify";

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $verifyUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode(['payment_id' => $paymentId]),
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "API-KEY: " . $apiKey,
        "SECRET-KEY: " . $secretKey,
        "BRAND-KEY: " . $brandKey
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

$result = json_decode($response, true);

if (isset($result['status']) && $result['status'] == 'success' && $result['payment_status'] == 'completed') {
    $orderId = $result['order_id']; // Or retrieve from metadata if needed
    $amount = $result['amount'];
    
    // Check if transaction already exists
    $payment = $conn->prepare("SELECT * FROM payments WHERE payment_extra=:extra");
    $payment->execute(["extra" => $orderId]);
    $payment = $payment->fetch(PDO::FETCH_ASSOC);

    if ($payment) {
        if ($payment["payment_status"] == "pending") {
            // Update Payment Status
            $update = $conn->prepare("UPDATE payments SET payment_status=:status, payment_delivery=:delivery WHERE payment_id=:id");
            $update->execute([
                "status" => "completed",
                "delivery" => 2, // 2 usually means auto-delivered in SMM panels
                "id" => $payment["payment_id"]
            ]);

            // Add Funds to User
            $user = $conn->prepare("SELECT * FROM clients WHERE client_id=:id");
            $user->execute(["id" => $payment["client_id"]]);
            $user = $user->fetch(PDO::FETCH_ASSOC);

            $balance = $user["balance"] + $amount;
            $updateUser = $conn->prepare("UPDATE clients SET balance=:balance WHERE client_id=:id");
            $updateUser->execute([
                "balance" => $balance,
                "id" => $payment["client_id"]
            ]);
            
            // Log or Notify
            header("Location: " . site_url("addfunds?success=true"));
            exit();
        } else {
            // Already processed
            header("Location: " . site_url("addfunds?error=already_processed"));
            exit();
        }
    } else {
        die("Payment record not found");
    }
} else {
    header("Location: " . site_url("addfunds?error=payment_failed"));
    exit();
}
