<?php
/* ePay WHMCS Callback File */

// Require libraries needed for gateway module functions.
require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

// Detect module name from filename.
$gatewayModuleName = 'epay';

// Fetch gateway configuration parameters.
$gatewayParams = getGatewayVariables($gatewayModuleName);

// Die if module is not active.
if (!$gatewayParams['type']) {
    die("Module Not Activated");
}

// Retrieve data returned in payment gateway callback
$invoiceId = $_GET['invoice_id'];
$paymentId = $_GET['payment_id'];
$transactionId = $_GET['payment_id']; // Use payment_id as transaction id

// Verify Payment
$apiKey = $gatewayParams['apiKey'];
$secretKey = $gatewayParams['secretKey'];
$brandKey = $gatewayParams['brandKey'];

$verifyUrl = 'https://secure.epay.com.bd/api/payment/verify';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $verifyUrl);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['payment_id' => $paymentId]));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'API-KEY: ' . $apiKey,
    'SECRET-KEY: ' . $secretKey,
    'BRAND-KEY: ' . $brandKey
));

$response = curl_exec($ch);
$result = json_decode($response, true);
curl_close($ch);

$success = false;
if (isset($result['status']) && $result['status'] == 'success' && $result['payment_status'] == 'completed') {
    $success = true;
    $amount = $result['amount']; // Amount paid
    // Note: You might need to convert back to invoice currency if needed
}

/**
 * Validate Callback Invoice ID.
 */
$invoiceId = checkCbInvoiceID($invoiceId, $gatewayParams['name']);

/**
 * Check Callback Transaction ID.
 */
checkCbTransID($transactionId);

/**
 * Log Transaction.
 */
logTransaction($gatewayParams['name'], $_GET, $success ? 'Success' : 'Failure');

if ($success) {
    /**
     * Add Payment to Invoice.
     */
    addInvoicePayment(
        $invoiceId,
        $transactionId,
        $amount,
        0,
        $gatewayModuleName
    );
    
    // Redirect to invoice
    $systemUrl = $gatewayParams['systemurl'];
    header("Location: {$systemUrl}viewinvoice.php?id={$invoiceId}&paymentsuccess=true");
} else {
    // Redirect to invoice with error
    $systemUrl = $gatewayParams['systemurl'];
    header("Location: {$systemUrl}viewinvoice.php?id={$invoiceId}&paymentfailed=true");
}