<?php
/* ePay WHMCS Gateway Module
 *
 * Website: https://epay.com.bd/
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function epay_MetaData()
{
    return array(
        'DisplayName' => 'ePay',
        'APIVersion' => '1.0',
        'DisableLocalCredtCardInput' => true,
        'TokenisedStorage' => false,
    );
}

function epay_config()
{
    return array(
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'ePay',
        ),
        'brandKey' => array(
            'FriendlyName' => 'Brand Key',
            'Type' => 'text',
            'Size' => '50',
            'Default' => '',
            'Description' => 'Enter your Brand Key',
        ),
        'apiKey' => array(
            'FriendlyName' => 'API Key',
            'Type' => 'text',
            'Size' => '50',
            'Default' => '',
            'Description' => 'Enter your API Key',
        ),
        'secretKey' => array(
            'FriendlyName' => 'Secret Key',
            'Type' => 'password',
            'Size' => '50',
            'Default' => '',
            'Description' => 'Enter your Secret Key',
        ),
        'currency_rate' => array(
            'FriendlyName' => 'Currency Rate (1 USD = ? BDT)',
            'Type' => 'text',
            'Size' => '10',
            'Default' => '110',
            'Description' => 'Conversion rate if base currency is not BDT',
        )
    );
}

function epay_link($params)
{
    // Payment Parameters
    $brandKey = $params['brandKey'];
    $apiKey = $params['apiKey'];
    $secretKey = $params['secretKey'];
    $currency_rate = $params['currency_rate'];

    // Invoice Parameters
    $invoiceId = $params['invoiceid'];
    $description = $params["description"];
    $amount = $params['amount'];
    $currencyCode = $params['currency'];

    // Client Parameters
    $firstname = $params['clientdetails']['firstname'];
    $lastname = $params['clientdetails']['lastname'];
    $email = $params['clientdetails']['email'];
    $address1 = $params['clientdetails']['address1'];
    $city = $params['clientdetails']['city'];
    $state = $params['clientdetails']['state'];
    $postcode = $params['clientdetails']['postcode'];
    $country = $params['clientdetails']['country'];
    $phone = $params['clientdetails']['phonenumber'];

    // System Parameters
    $systemUrl = $params['systemurl'];
    $returnUrl = $params['returnurl'];
    $langPayNow = $params['langpaynow'];
    $moduleDisplayName = $params['name'];
    $moduleName = $params['paymentmethod'];
    $whmcsVersion = $params['whmcsVersion'];

    // Convert to BDT if needed
    if ($currencyCode != 'BDT') {
        $amount = round($amount * $currency_rate, 2);
    }

    $postfields = array();
    $postfields['cus_name'] = $firstname . ' ' . $lastname;
    $postfields['cus_email'] = $email;
    $postfields['cus_phone'] = $phone;
    $postfields['amount'] = $amount;
    $postfields['order_id'] = $invoiceId;
    $postfields['success_url'] = $systemUrl . 'modules/gateways/callback/epay.php?invoice_id=' . $invoiceId;
    $postfields['cancel_url'] = $returnUrl;
    $postfields['metadata'] = json_encode(['invoice_id' => $invoiceId]);

    $url = 'https://secure.epay.com.bd/api/payment/create';

    $htmlOutput = '<form method="post" action="' . $url . '">';
    
    // Since the API requires JSON body, we can't just use a simple form submit to the API endpoint directly 
    // if the API expects JSON. 
    // However, looking at the previous code, it was doing a redirect.
    // Let's use an intermediate approach: Create the payment via cURL here, then redirect the user.
    
    // API Call to create payment
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postfields));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'API-KEY: ' . $apiKey,
        'SECRET-KEY: ' . $secretKey,
        'BRAND-KEY: ' . $brandKey
    ));
    
    $response = curl_exec($ch);
    $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    $result = json_decode($response, true);
    
    if (isset($result['status']) && $result['status'] == 'success' && isset($result['payment_url'])) {
        $paymentUrl = $result['payment_url'];
        
        $htmlOutput = '<form method="get" action="' . $paymentUrl . '">';
        $htmlOutput .= '<input type="submit" value="' . $langPayNow . '" class="btn btn-primary" />';
        $htmlOutput .= '</form>';
    } else {
        $htmlOutput = '<div class="alert alert-danger">Payment Error: ' . ($result['message'] ?? 'Unknown Error') . '</div>';
    }

    return $htmlOutput;
}