<?php
/**
 * Plugin Name: ePay Payment Gateway
 * Plugin URI: https://epay.com.bd
 * Description: Secure Payment Gateway for WooCommerce. Connect simply using your Brand Key.
 * Version: 1.0.0
 * Author: ePay
 * Author URI: https://epay.com.bd
 * Text Domain: epay-payment-gateway
 * Domain Path: /i18n/languages/
 *
 * @package ePay
 */

defined( 'ABSPATH' ) || exit;

// Define Constants
define( 'EPAY_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'EPAY_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'EPAY_VERSION', '1.0.0' );

/**
 * Initialize the gateway.
 */
function epay_init_gateway_class() {
    if ( ! class_exists( 'WC_Payment_Gateway' ) ) {
        return;
    }

    require_once EPAY_PLUGIN_DIR . 'includes/class-wc-epay-gateway.php';
}
add_action( 'plugins_loaded', 'epay_init_gateway_class' );

/**
 * Add the gateway to WooCommerce.
 */
function epay_add_gateway_class( $methods ) {
    $methods[] = 'WC_Gateway_ePay';
    return $methods;
}
add_filter( 'woocommerce_payment_gateways', 'epay_add_gateway_class' );

/**
 * Add Settings Link to Plugin List
 */
function epay_plugin_links( $links ) {
    $plugin_links = array(
        '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout&section=epay' ) . '">' . __( 'Settings', 'epay-payment-gateway' ) . '</a>',
    );
    return array_merge( $plugin_links, $links );
}
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'epay_plugin_links' );
